﻿<%@ Page Title="DoD Fragment Raw Data" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" 
    CodeBehind="DoDFragmentRawData.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.DoDFragmentRawData" %>

<%@ Register src="~/Controls/Custom/EFR/BaseControlLabel.ascx" tagname="BaseControlLabel" 
tagprefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
    <style type="text/css">
        .style1
        {
            width: 15%;
        }
        .style2
        {
            width: 25%;
        }
    </style>
    <script src="scripts/jquery-1[1].3.2.js" type="text/javascript"></script>
    
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <asp:GridView ID = "GridViewEFRFragmentsRawData" runat = "server" 
        OnRowCommand = "FragmentsRawData_RowCommand" 
        AutoGenerateColumns = "false"
        AllowPaging="True" 
        PageSize="20" 
        DataKeyNames = "DOD_FRAGMENT_RAW_DATA_ID"  
        AllowSorting = "true"
        SkinID = "Unsortable" Width="100%"
        UseAccessibleHeader = "true"
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
        <EmptyDataTemplate>
            No source DoD fragments data found for this patient 
        </EmptyDataTemplate>                     
        <Columns>
            <asp:TemplateField AccessibleHeaderText = "File Name" HeaderText = "File Name" >
                <ItemTemplate>
                     <asp:Label ID = "LabelFileName" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ORIGINAL_NAME"))) %>' SkinID = "DataLabel" /> 
                                
                </ItemTemplate>
             </asp:TemplateField>
             
             <asp:TemplateField AccessibleHeaderText = "Content Type" HeaderText = "Content Type">    
                <ItemTemplate>
                    <asp:Label ID = "LabelFileContentType" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CONTENT_TYPE"))) %>' SkinID = "DataLabel" />
                              
                </ItemTemplate> 
             </asp:TemplateField>    
                
              <asp:TemplateField AccessibleHeaderText = "Date Received" HeaderText = "Date Received">    
                <ItemTemplate>
                    <asp:Label ID = "LabelFileReceivedDate" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReceivedDate", "{0:d}"))) %>' SkinID = "DataLabel" />                                          </ItemTemplate> 
             </asp:TemplateField>    
                               
              <asp:TemplateField AccessibleHeaderText = "Lab Report Date" HeaderText = "Lab Report Date">    
                <ItemTemplate>
                    <asp:Label ID = "LabelLabReportDate" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(DisplayFormatDate(Eval("LAB_REPORT_DATE") as DateTime?)) %> ' SkinID = "DataLabel" />                                          </ItemTemplate> 
             </asp:TemplateField>    
                               
             <asp:ButtonField ButtonType = "Button" Text = "Open / Download" CommandName = "Details" AccessibleHeaderText = "Open / Download"  ItemStyle-HorizontalAlign="Center" />
                
        </Columns> 
        </asp:GridView> 
     <br />    
       <br />        
       <asp:HiddenField ID="HiddenFieldPatientID" runat="server" />
       <table width="100%"><tr><td align="right">
            <asp:Button ID="ButtonBack" runat="server" Text="  Back  " 
            onclick="ButtonBack_Click" />
        </td></tr></table> 
    <asp:ObjectDataSource ID = "ObjectDataSourceDoDFragmentRawData" runat = "server" 
    SelectMethod="SelectDoDFragmentsRawDataByPatientId"  
        SelectCountMethod="SelectDoDFragmentsRawDataByPatientIdCount" 
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        EnablePaging="True" 
        TypeName="VIRP.EFR.DAL.DoDFragmentDB">
        <SelectParameters>            
            <asp:QueryStringParameter 
                Name = "patientId" 
                QueryStringField = "patientId" 
                DefaultValue="0" />
                                
        </SelectParameters>
     </asp:ObjectDataSource>     
    
</asp:Content>

